const express = require('express');
const dotenv = require('dotenv');
const cookieparser = require('cookie-parser');
const path = require('path');
const cors = require('cors');
const { resError, mainError } = require('./app/helpers/res');
const auth = require('./app/middleware/auth');
const date = require('./app/middleware/Datechecker');
dotenv.config();
global.root = __dirname;
const app = express();
// app.disable('x-powered-by');
app.use(cookieparser());
app.use(express.json()); // req josn data to js object
app.use(express.urlencoded({ extended: true })); // req form data to js object
app.use(express.static(path.join(global.root, '/public')));
app.use(cors());
//-------edite area--------------
const prefix = "/api/v1";
app.use(prefix + "/user", require('./app/routes/userRoute'));
app.use(prefix + "/customar", auth,date, require('./app/routes/customarRoute'));
app.use(prefix + "/bill", auth, date, require('./app/routes/billRoute'));

//-------edite area end--------------
app.use(mainError);
app.listen(process.env.PORT, () => {
    console.log(`server is running on port ${process.env.PORT}`);
})
