const Controller = require("./Controller");
const { resSuccess } = require("../helpers/res");
const database = require("../configs/database");
const transection = require("../helpers/transection");
async function getdata(date) {
    const customar = await database.table('customar').orderBy('lastupdate', 'desc');
    const sendata = [];
    for (let cus of customar) {
        cus.todaybill = 0;
        cus.todaypay = 0;
        const todaybill = await database.table('transection').where('date', '=', date).andWhere('user_id', '=', cus.id);
        if (todaybill.length > 0) {
            const bill = todaybill.reduce((ol, nw) => ol += parseFloat(nw['credit']), 0);
            const pay = todaybill.reduce((ol, nw) => ol += parseFloat(nw['debit']), 0);
            cus.todaybill = bill.toFixed(1).replace('-', 'advance ');
            cus.todaypay = pay.toFixed(1).replace('-', 'advance ');
        }
        cus.taka = cus.taka.toString().replace('-', 'advance ');
        // console.log(cus)
        sendata.push(cus);
    }
    return sendata;
}
class CustomarController extends Controller {
    async store(req, res, next) {
        try {
            const { name, mobail } = req.body;
            if (!name || !mobail) {
                return next('name and mobail empty!!')
            }
            const data = {
                name,
                mobail,
                creator: req.user.name,
            }
            const newdata = await database.table('customar').insert(data);
            const daya = await getdata(req.date);
            return res.json(resSuccess('customar add success', daya));
        } catch (error) {
            return next(error)
        }
    }
    async update(req, res, next) {
        try {
            const { id } = req.params;
            const { name, mobail } = req.body;
            if (!name || !mobail) {
                return next("input empty");
            }
            const user = await database.table("customar").where("id", "=", id).first();
            if (user == null) {
                return next("invali id");
            }
            await database.table("customar").where("id", "=", user.id).update({
                name, mobail
            });
            const daya = await getdata(req.date);
            return res.json(resSuccess("update successfull", daya));
        } catch (error) {
            return next(error);
        }
    }
    async remove(req, res, next) {
        try {
            const { id } = req.params;
            const user = database.table("customar").where("id", "=".id).first();
            if (!user) {
                return next("invali id");
            }
            await database.table("customar").where("id", "=", id).delete();
            const daya = await getdata(req.date);
            return res.json(resSuccess("remove successfull", daya));
        } catch (error) {
            return next(error);
        }
    }
    async bill(req, res, next) {
        try {
            const { type, taka } = req.body;
            const { id } = req.params;
            if (!type || !id || !taka) {
                return next("type id taka is empty")
            }
            if (isNaN(taka)) {
                return next("invalid taka");
            }
            const odltata = await database.table('customar').where("id", "=", id).first();
            if (!odltata) {
                return next("invalid user");
            }
            let total = 0;
            if (type == "add") {
                total = parseFloat(odltata['taka']) + parseFloat(taka)
            } else if (type == "remove") {
                total = parseFloat(odltata['taka']) - parseFloat(taka)
            }
            await database.table('customar').where("id", "=", id).update({
                taka: total,
                lastupdate: Date.now()
            })
            if (type == 'add') {
                await transection(req.date, id, "0", parseFloat(taka).toFixed(1), total.toFixed(1), req.user.name, 'customar');

            } else if (type == "remove") {
                await transection(req.date, id, parseFloat(taka).toFixed(1), "0", total.toFixed(1), req.user.name, 'customar');
            }
            const daya = await getdata(req.date);
            return res.json(resSuccess('Bill add success', daya));
        } catch (error) {
            return next(error);
        }
    }
    async history(req, res, next) {
        try {
            const model = {
                today: [],
                old: [],
                total_dew: 0,
                pay: 0,
                finalydew: 0,
                name: '',
                mobail: ''
            }
            const date = req.date;
            const { id } = req.params;
            const user = await database.table("customar").where("id", "=", id).first();
            if (user == null) {
                return next("invali id");
            }
            const history = await database.table('transection').where("user_id", "=", id).andWhere("type", "=", 'customar');

            model.name = user.name;
            model.finalydew = user.taka.replace('-',' advance ');
            model.mobail = user.mobail;
            if (history.length > 0) {
                model.today = history.filter((item) => item.date === date).reverse();
                model.old = history.reverse();
                model.total_dew = history.filter((itme) => itme.credit != "0").reduce((o, n) => o += parseFloat(n.credit), 0);
                model.pay = history.filter((itme) => itme.debit != "0").reduce((o, n) => o += parseFloat(n.debit), 0);
            }
            return res.json(resSuccess("transection history", model));
        } catch (error) {
            return next(error);
        }
    }
    async get(req, res, next) {
        try {
            const daya = await getdata(req.date);
            return res.json(resSuccess('Bill get success', daya));
        } catch (error) {
            return next(error);
        }
    }
}
module.exports = new CustomarController;