const Controller = require("./Controller");
const crypto = require('crypto');
const brypto = require('bcryptjs');
const { resSuccess } = require("../helpers/res");
const database = require("../configs/database");
class UserController extends Controller {
    async add(req, res, next) {
        try {
            const { name, mobail, pass } = req.body;
            if (!name || !mobail || !pass) {
                return next("name and mobail and pass requird");
            }
            const mobailcheck = await database.table('users').select("*").where("mobail", "=", mobail);
            if (mobailcheck.length > 0) {
                return next("This mobail number already exist!!")
            }
            const pas = brypto.hashSync(pass, 10)
            const user = await database.table('users')
                .insert({
                    name,
                    mobail,
                    pass: pas
                })
            return res.json(resSuccess("User Create success"));
        } catch (error) {
            return next(error);
        }
    }
    async auth(req, res, next) {
        try {
            const { mobail, pass } = req.body;
            if (!mobail || !pass) {
                return next("name and mobail and pass requird");
            }
            if (isNaN(mobail)) {
                return next("mobail number only typeof number");
            }
            const mobailcheck = await database.table('users').select("*").where("mobail", "=", mobail);
            if (mobailcheck.length == 0) {
                return next("Invalid credentials")
            }
            const compare = brypto.compareSync(pass, mobailcheck[0].pass);
            if (!compare) {
                return next("Invalid credentials")
            }
            //crate csrf toekn
            const csrf = crypto.randomBytes(20).toString("hex").slice(0, 20);
            await database.table("token").insert({ _token: csrf, table_name: "users", user_id: mobailcheck[0].id })

            return res.json(resSuccess("Login success", { token: csrf }));
        } catch (error) {
            console.log(error.toString());
            return next(error);
        }
    }
    async refreshToekn(req, res, next) {
        try {
            const id = req.user.id;
            const toekn_id = req.token.id;
            const csrf = crypto.randomBytes(20).toString("hex").slice(0, 20);
            await database.table("token").where("id", "=", toekn_id).insert({ _token: csrf, table_name: "users", user_id: id })
            return res.json(resSuccess("Login success", { token: csrf }));
        } catch (error) {
            console.log(error.toString());
            return next(error);
        }
    }
    async profileUpdateToekn(req, res, next) {
        try {
            const id = req.user.id;
            const csrf = crypto.randomBytes(32).toString("hex").slice(0, 32);
            await database.table("users").where("id", id).update({ token_key: csrf })
            return res.json(resSuccess("Login success", { token: csrf }));
        } catch (error) {
            console.log(error.toString());
            return next(error);
        }
    }
    async checkprofiletoekn(req, res, next) {
        try {
            const { _token } = req.body;
            if (!_token) {
                return next("_token requird");
            }
            const mobailcheck = await database.table('users').select("*").where("token_key", "=", _token);
            if (mobailcheck.length == 0) {
                return next("Invalid token!!")
            }
            return res.json(resSuccess("successful"));
        } catch (error) {
            return next(error);
        }
    }
    profile(req, res, next) {
        try {
            const user = req.user;
            return res.json(resSuccess("user profile",user));
        } catch (error) {
            return next(error);
        }
    }
}
module.exports = new UserController;