const Controller = require("./Controller");
const { resSuccess } = require("../helpers/res");
const database = require("../configs/database");
class billController extends Controller {
    async store(req, res, next) {
        try {
            const { title, taka } = req.body;
            if (!title || !taka) {
                return next("title and taka requird");
            }
            if (isNaN(taka)) {
                return next("taka typeof number");
            }
            const user = req.user;
            const time = new Date();
            await database.table('bills').insert({
                title, taka, creator: user.name, date_time: req.date, time: time.toLocaleTimeString('en-US'),
            })
            return res.json(resSuccess("bill store success"));
        } catch (error) {
            return this.error(res, error);
        }
    }
    async update(req, res, next) {
        try {
            const { title, taka, commnet } = req.body;
            const { id } = req.params;
            if (!id || !title || !taka) {
                return next("id and title and taka requird");
            }
            if (isNaN(taka)) {
                return next("taka typeof number");
            }
            const billcheck = await database.table('bills').select("*").where("id", "=", id);
            if (billcheck.length == 0) {
                return next("Invalid bill id");
            }
            await database.table('bills').where("id", "=", id).update({
                title, taka, commnet
            })
            return res.json(resSuccess("bill update success"));
        } catch (error) {
            return next(error);
        }
    }
    async remove(req, res, next) {
        try {
            const { id } = req.params;
            if (!id) {
                return next("id requird");
            }
            const billcheck = await database.table('bills').select("*").where("id", "=", id);
            if (billcheck.length == 0) {
                return next("Invalid bill id");
            }
            await database.table('bills').where("id", "=", id).delete();
            return res.json(resSuccess("bill delete success"));
        } catch (error) {
            return next(error);
        }
    }
    async index(req, res, next) {
        try {
            const datas = (await database.table("bills").where("date_time", "=", req.date)).reverse();
            if (datas.length == 0) {
                return next("data not found!");
            }
            const total = datas.reduce((pre, cur) => pre += parseFloat(cur.taka), 0);
            return res.json(resSuccess("bill get success", {
                total,
                datas
            }));;
        } catch (error) {
            return next(error);
        }
    }
}
module.exports = new billController;