const database = require("../configs/database");

module.exports = async function auth(req, res, next) {
    try {
        const toekn = req.header('authorization');
        if (!toekn) {
            return next('Invalid credentials');
        }
        const arrayCreate = toekn.split(' ');
        if (arrayCreate.length != 2) {
            return next('Invalid credentials');
        }
        //check user in toekn dababse
        const usersid = await database.table('token')
            .where('_token', '=', arrayCreate[1]).where('table_name', '=', 'users');
        if (usersid.length == 0) {
            return next('Invalid credentials');
        }
        const id = usersid[0]['user_id'];
        const users = await database.table('users').where('id', '=', id);
        if (users.length == 0) {
            return next('Invalid credentials');
        }
        const user = users[0];
        if (user['status'] == 2) {
            return next('Your acound deactived!!');
        }
        req.token = usersid[0];
        req.user = user;
        next();
    } catch (error) {
        console.log("auth error");
        return next(error);
    }
}