const express = require("express");
const UserController = require("../controllers/UserController");
const AuhtMidelware = require("../middleware/auth");

const userRouter = express.Router();

userRouter.post("/", UserController.add);
userRouter.post("/login", UserController.auth);
userRouter.post("/ref",AuhtMidelware, UserController.refreshToekn);
userRouter.post("/ref-profile",AuhtMidelware, UserController.profileUpdateToekn);
userRouter.post("/ref-profile-check",AuhtMidelware, UserController.checkprofiletoekn);
userRouter.get("/profile",AuhtMidelware, UserController.profile);
module.exports = userRouter;